-- -----------------------------------------------
-- OPIS  : Tworzenie startowych tabel
-- AUTOR : Marcin Jabłoński
-- DATA  : 2019-01-21

-- EDYCJA: 2020-07-08
--		   Dodano tworzenie tabeli towary
--		   Dariusz Szkatuła
-- -----------------------------------------------

USE `projekt`;
-- Zrzut struktury tabela projekt.adresy
CREATE TABLE IF NOT EXISTS `adresy` (
  `id` int(10) unsigned NOT NULL auto_increment,
  `Imie` varchar(20) default NULL,
  `Nazwisko` varchar(20) default NULL,
  `Nazwa` varchar(25) default NULL,
  `Ulica` varchar(60) default NULL,
  `Kod` varchar(6) default NULL,
  `Miejscowosc` varchar(35) default NULL,
  `NrTel1` varchar(20) default NULL,
  `NrTel2` varchar(20) default NULL,
  `TelKom` varchar(20) default NULL,
  `Fax` varchar(20) default NULL,
  `NIP` varchar(20) default NULL,
  `Regon` varchar(20) default NULL,
  `Uwagi` varchar(100) default NULL,
  `emailAdres` varchar(100) default NULL,
  PRIMARY KEY  (`id`),
  KEY `NazwaFirmy` (`Nazwa`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- Zrzucanie danych dla tabeli projekt.adresy: ~0 rows (około)
DELETE FROM `adresy`;

-- Zrzut struktury tabela projekt.dodatkidookna
CREATE TABLE IF NOT EXISTS `dodatkidookna` (
  `id` int(11) unsigned NOT NULL auto_increment,
  `idPozycji` int(11) unsigned NOT NULL default '0',
  `idElementu` int(11) unsigned NOT NULL default '0',
  `Nazwa` varchar(100) NOT NULL default '',
  `SymbolWew` varchar(100) NOT NULL default '',
  `Ilosc` int(10) unsigned NOT NULL default '1',
  `WymiarX` int(10) unsigned NOT NULL default '0',
  `WymiarY` int(10) unsigned NOT NULL default '0',
  `Netto` decimal(12,2) default NULL,
  `CenaJednN` decimal(10,2) default '0.00',
  `idZlecenia` int(11) unsigned NOT NULL default '0',
  `CenaBruttoZak` decimal(12,2) default '0.00',
  PRIMARY KEY  (`id`),
  KEY `idPozycji` (`idPozycji`),
  KEY `idZlecenia` (`idZlecenia`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- Zrzucanie danych dla tabeli projekt.dodatkidookna: ~0 rows (około)
DELETE FROM `dodatkidookna`;

-- Zrzut struktury tabela projekt.elementyokiendoproj
CREATE TABLE IF NOT EXISTS `elementyokiendoproj` (
  `id` int(11) unsigned NOT NULL auto_increment,
  `idPozycji` int(11) unsigned NOT NULL default '0',
  `CzyKlamka` int(1) NOT NULL default '0',
  `CzyZawias` int(1) NOT NULL default '0',
  `idElementu` int(11) unsigned NOT NULL default '0',
  `idKlamki` int(11) unsigned NOT NULL default '0',
  `idOslonek` int(11) unsigned NOT NULL default '0',
  `idOkucia` int(11) unsigned NOT NULL default '0',
  `Warstwa` int(11) unsigned NOT NULL default '0',
  `GrupaPr` int(11) unsigned NOT NULL default '0',
  `Nazwa` varchar(100) NOT NULL default '',
  `SymbolWew` varchar(100) NOT NULL default '',
  `KatLewy1` float(8,4) NOT NULL default '0.0000',
  `KatPrawy1` float(8,4) NOT NULL default '0.0000',
  `KatLewy2` float(8,4) NOT NULL default '0.0000',
  `KatPrawy2` float(8,4) NOT NULL default '0.0000',
  `TypPolLewy` int(3) NOT NULL default '0',
  `TypPolPrawy` int(3) NOT NULL default '0',
  `KolorLinii` int(11) unsigned NOT NULL default '0',
  `KolorWypelnienia` int(11) unsigned NOT NULL default '0',
  `GruboscLinii` int(11) unsigned NOT NULL default '0',
  `PktPoczX` float(12,8) unsigned NOT NULL default '0.00000000',
  `PktPoczY` float(12,8) unsigned NOT NULL default '0.00000000',
  `PktKonX` float(12,8) unsigned NOT NULL default '0.00000000',
  `PktKonY` float(12,8) unsigned NOT NULL default '0.00000000',
  `PktPoczZX` float(12,8) unsigned NOT NULL default '0.00000000',
  `PktPoczZY` float(12,8) unsigned NOT NULL default '0.00000000',
  `PktPoczSX` float(12,8) unsigned NOT NULL default '0.00000000',
  `PktPoczSY` float(12,8) unsigned NOT NULL default '0.00000000',
  `PktPoczWX` float(12,8) unsigned NOT NULL default '0.00000000',
  `PktPoczWY` float(12,8) unsigned NOT NULL default '0.00000000',
  `PktKonZX` float(12,8) unsigned NOT NULL default '0.00000000',
  `PktKonZY` float(12,8) unsigned NOT NULL default '0.00000000',
  `PktKonSX` float(12,8) unsigned NOT NULL default '0.00000000',
  `PktKonSY` float(12,8) unsigned NOT NULL default '0.00000000',
  `PktKonWX` float(12,8) unsigned NOT NULL default '0.00000000',
  `PktKonWY` float(12,8) unsigned NOT NULL default '0.00000000',
  `Wysokosc` float(6,2) NOT NULL default '0.00',
  `SasiadLewy` int(11) unsigned NOT NULL default '0',
  `SasiadPrawy` int(11) unsigned NOT NULL default '0',
  `TypElementu` int(2) NOT NULL default '0',
  `Promien` int(11) NOT NULL default '0',
  `GrupaEl` int(11) NOT NULL default '0',
  `OdsNaSzklo` float(5,2) NOT NULL default '0.00',
  `OdsNaSlupek` float(5,2) NOT NULL default '0.00',
  `OdsNaSkrzydlo` float(5,2) NOT NULL default '0.00',
  `OdsNaListwe` float(5,2) NOT NULL default '0.00',
  `TypBoku` int(2) unsigned default '0',
  `KorWymLewa` float(4,2) NOT NULL default '0.00',
  `KorWymPrawa` float(4,2) NOT NULL default '0.00',
  `ElNadrzedny` int(11) unsigned NOT NULL default '0',
  `ElNadrzedny1` int(11) unsigned NOT NULL default '0',
  `TypOkucia` int(2) unsigned NOT NULL default '0',
  `CzyMoznaUsunac` int(2) default '0',
  `Wskaznik` int(11) unsigned NOT NULL default '0',
  `MaxDl` float(8,2) default '0.00',
  `MaxPow` float(8,2) default '0.00',
  `WspK` float(8,2) default '0.00',
  `WspPsi` float(8,2) default '0.00',
  `CzyRuch` int(2) default '0',
  `MaxKat` int(3) default '0',
  `KolorNazwa` varchar(100) default '',
  `MaxStBok` int(3) default '0',
  `GruboscPakietu` int(3) default '0',
  `NazwaOkucia` varchar(100) default '',
  `KolorListwa` varchar(100) default 'Bia?y',
  `TypNazwa` varchar(100) default '',
  `Technologia` varchar(100) default '',
  `idUszczelek` int(11) unsigned default '0',
  `NazwaKlamki` varchar(100) default '',
  `NazwaOslonek` varchar(100) default '',
  `NazwaUszczelek` varchar(100) default '',
  `KolorKlamki` int(11) unsigned default '0',
  `idNawiewnika` int(11) unsigned default '0',
  `NazwaNawiewnika` varchar(100) default '',
  PRIMARY KEY  (`id`),
  KEY `idPozycji` (`idPozycji`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- Zrzucanie danych dla tabeli projekt.elementyokiendoproj: ~0 rows (około)
DELETE FROM `elementyokiendoproj`;

-- Zrzut struktury tabela projekt.elementyokiendoprojgal
CREATE TABLE IF NOT EXISTS `elementyokiendoprojgal` (
  `id` int(11) unsigned NOT NULL auto_increment,
  `idPozycji` int(11) unsigned NOT NULL default '0',
  `CzyKlamka` int(1) NOT NULL default '0',
  `CzyZawias` int(1) NOT NULL default '0',
  `idElementu` int(11) unsigned NOT NULL default '0',
  `idKlamki` int(11) unsigned NOT NULL default '0',
  `idOslonek` int(11) unsigned NOT NULL default '0',
  `idOkucia` int(11) unsigned NOT NULL default '0',
  `Warstwa` int(11) unsigned NOT NULL default '0',
  `GrupaPr` int(11) unsigned NOT NULL default '0',
  `Nazwa` varchar(100) NOT NULL default '',
  `SymbolWew` varchar(100) NOT NULL default '',
  `KatLewy1` float(8,4) NOT NULL default '0.0000',
  `KatPrawy1` float(8,4) NOT NULL default '0.0000',
  `KatLewy2` float(8,4) NOT NULL default '0.0000',
  `KatPrawy2` float(8,4) NOT NULL default '0.0000',
  `TypPolLewy` int(3) NOT NULL default '0',
  `TypPolPrawy` int(3) NOT NULL default '0',
  `KolorLinii` int(11) unsigned NOT NULL default '0',
  `KolorWypelnienia` int(11) unsigned NOT NULL default '0',
  `GruboscLinii` int(11) unsigned NOT NULL default '0',
  `PktPoczX` float(12,8) unsigned NOT NULL default '0.00000000',
  `PktPoczY` float(12,8) unsigned NOT NULL default '0.00000000',
  `PktKonX` float(12,8) unsigned NOT NULL default '0.00000000',
  `PktKonY` float(12,8) unsigned NOT NULL default '0.00000000',
  `PktPoczZX` float(12,8) unsigned NOT NULL default '0.00000000',
  `PktPoczZY` float(12,8) unsigned NOT NULL default '0.00000000',
  `PktPoczSX` float(12,8) unsigned NOT NULL default '0.00000000',
  `PktPoczSY` float(12,8) unsigned NOT NULL default '0.00000000',
  `PktPoczWX` float(12,8) unsigned NOT NULL default '0.00000000',
  `PktPoczWY` float(12,8) unsigned NOT NULL default '0.00000000',
  `PktKonZX` float(12,8) unsigned NOT NULL default '0.00000000',
  `PktKonZY` float(12,8) unsigned NOT NULL default '0.00000000',
  `PktKonSX` float(12,8) unsigned NOT NULL default '0.00000000',
  `PktKonSY` float(12,8) unsigned NOT NULL default '0.00000000',
  `PktKonWX` float(12,8) unsigned NOT NULL default '0.00000000',
  `PktKonWY` float(12,8) unsigned NOT NULL default '0.00000000',
  `Wysokosc` float(6,2) NOT NULL default '0.00',
  `SasiadLewy` int(11) unsigned NOT NULL default '0',
  `SasiadPrawy` int(11) unsigned NOT NULL default '0',
  `TypElementu` int(2) NOT NULL default '0',
  `Promien` int(11) NOT NULL default '0',
  `GrupaEl` int(11) NOT NULL default '0',
  `OdsNaSzklo` float(5,2) NOT NULL default '0.00',
  `OdsNaSlupek` float(5,2) NOT NULL default '0.00',
  `OdsNaSkrzydlo` float(5,2) NOT NULL default '0.00',
  `OdsNaListwe` float(5,2) NOT NULL default '0.00',
  `TypBoku` int(2) unsigned default '0',
  `KorWymLewa` float(4,2) NOT NULL default '0.00',
  `KorWymPrawa` float(4,2) NOT NULL default '0.00',
  `ElNadrzedny` int(11) unsigned NOT NULL default '0',
  `ElNadrzedny1` int(11) unsigned NOT NULL default '0',
  `TypOkucia` int(2) unsigned NOT NULL default '0',
  `CzyMoznaUsunac` int(2) default '0',
  `Wskaznik` int(11) unsigned NOT NULL default '0',
  `MaxDl` float(8,2) default '0.00',
  `MaxPow` float(8,2) default '0.00',
  `WspK` float(8,2) default '0.00',
  `WspPsi` float(8,2) default '0.00',
  `CzyRuch` int(2) default '0',
  `MaxKat` int(3) default '0',
  `KolorNazwa` varchar(100) default '',
  `MaxStBok` int(3) default '0',
  `GruboscPakietu` int(3) default '0',
  `NazwaOkucia` varchar(100) default '',
  `KolorListwa` varchar(100) default 'Bia?y',
  `TypNazwa` varchar(100) default '',
  `Technologia` varchar(100) default '',
  `idUszczelek` int(11) unsigned default '0',
  `NazwaKlamki` varchar(100) default '',
  `NazwaOslonek` varchar(100) default '',
  `NazwaUszczelek` varchar(100) default '',
  `KolorKlamki` int(11) unsigned default '0',
  `idNawiewnika` int(11) unsigned default '0',
  `NazwaNawiewnika` varchar(100) default '',
  PRIMARY KEY  (`id`),
  KEY `idPozycji` (`idPozycji`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- Zrzucanie danych dla tabeli projekt.elementyokiendoprojgal: ~0 rows (około)
DELETE FROM `elementyokiendoprojgal`;

-- Zrzut struktury tabela projekt.jednmiar
CREATE TABLE IF NOT EXISTS `jednmiar` (
  `id` int(10) unsigned NOT NULL auto_increment,
  `Jm` varchar(100) NOT NULL default '',
  PRIMARY KEY  (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- Zrzucanie danych dla tabeli projekt.jednmiar: ~0 rows (około)
DELETE FROM `jednmiar`;

-- Zrzut struktury tabela projekt.kolory
CREATE TABLE IF NOT EXISTS `kolory` (
  `id` int(10) unsigned NOT NULL auto_increment,
  `Kolor` varchar(100) NOT NULL default '',
  PRIMARY KEY  (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- Zrzucanie danych dla tabeli projekt.kolory: ~0 rows (około)
DELETE FROM `kolory`;

-- Zrzut struktury tabela projekt.laczniki
CREATE TABLE IF NOT EXISTS `laczniki` (
  `id` int(10) unsigned NOT NULL auto_increment,
  `idZlecenia` int(10) unsigned NOT NULL default '0',
  `idElementu` int(11) NOT NULL default '0',
  `Wymiar` int(11) NOT NULL default '0',
  `Ilosc` int(11) NOT NULL default '0',
  `CenaNetto` decimal(10,2) NOT NULL default '0.00',
  `Nazwa` varchar(100) default NULL,
  `SymbolWew` varchar(100) default '',
  `OstEdycja` varchar(100) default '',
  `CzyOdpad` int(1) default '0',
  `CenaBruttoZak` decimal(10,2) default '0.00',
  PRIMARY KEY  (`id`),
  KEY `idZlecenia` (`idZlecenia`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- Zrzucanie danych dla tabeli projekt.laczniki: ~0 rows (około)
DELETE FROM `laczniki`;

-- Zrzut struktury tabela projekt.montaz
CREATE TABLE IF NOT EXISTS `montaz` (
  `nazwa` varchar(60) NOT NULL default '',
  `Cena` decimal(12,2) NOT NULL default '0.00',
  PRIMARY KEY  (`nazwa`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- Zrzucanie danych dla tabeli projekt.montaz: ~0 rows (około)
DELETE FROM `montaz`;

-- Zrzut struktury tabela projekt.naglpozycji
CREATE TABLE IF NOT EXISTS `naglpozycji` (
  `id` int(10) unsigned NOT NULL auto_increment,
  `WymiarX` int(11) NOT NULL default '0',
  `WymiarY` int(11) NOT NULL default '0',
  `idZlecenia` int(10) unsigned NOT NULL default '0',
  `Pozycja` int(10) unsigned NOT NULL default '0',
  `Ilosc` int(10) unsigned NOT NULL default '0',
  `CenaJedn` decimal(12,2) NOT NULL default '0.00',
  `Uwagi` mediumblob,
  `WspK` decimal(10,4) default '0.0000',
  `Waga` decimal(10,4) default '0.0000',
  `Zrobionych` int(10) default '0',
  `JednOk` float(10,2) default '0.00',
  `Technologia` varchar(100) default '',
  `Okucie` varchar(50) default NULL,
  `CenaMontazu` decimal(12,2) NOT NULL default '0.00',
  `CenaJednDet` decimal(12,2) default '0.00',
  `TypOkna` varchar(100) default '',
  `OstEdycja` varchar(100) default '',
  `InneDopl` mediumblob,
  `DataEdycji` datetime default NULL,
  `IloscZDem` int(5) unsigned default '0',
  `RabatP` int(4) default '0',
  `RabatT` int(4) default '0',
  `RabatD` int(4) default '0',
  `CzyTypowe` int(2) default '0',
  `MontRodz` varchar(100) default '',
  `UwagiOfert` mediumblob,
  `CenaJednZak` decimal(12,2) default '0.00',
  PRIMARY KEY  (`id`),
  KEY `idZlecenia` (`idZlecenia`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- Zrzucanie danych dla tabeli projekt.naglpozycji: ~0 rows (około)
DELETE FROM `naglpozycji`;

-- Zrzut struktury tabela projekt.naglpozycjigal
CREATE TABLE IF NOT EXISTS `naglpozycjigal` (
  `id` int(10) unsigned NOT NULL auto_increment,
  `WymiarX` int(11) NOT NULL default '0',
  `WymiarY` int(11) NOT NULL default '0',
  `Technologia` varchar(100) default '',
  `Nazwa` varchar(100) default '',
  PRIMARY KEY  (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- Zrzucanie danych dla tabeli projekt.naglpozycjigal: ~0 rows (około)
DELETE FROM `naglpozycjigal`;

-- Zrzut struktury tabela projekt.parapety
CREATE TABLE IF NOT EXISTS `parapety` (
  `id` int(10) unsigned NOT NULL auto_increment,
  `Typ` int(2) NOT NULL default '0',
  `Rodzaj` varchar(100) NOT NULL default '',
  `Szer` decimal(10,0) NOT NULL default '0',
  `Cena` decimal(10,2) NOT NULL default '0.00',
  `CenaZakN` decimal(10,2) NOT NULL default '0.00',
  PRIMARY KEY  (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- Zrzucanie danych dla tabeli projekt.parapety: ~0 rows (około)
DELETE FROM `parapety`;

-- Zrzut struktury tabela projekt.parapetyzam
CREATE TABLE IF NOT EXISTS `parapetyzam` (
  `id` int(11) unsigned NOT NULL auto_increment,
  `idZlecenia` int(10) unsigned NOT NULL default '0',
  `Nazwa` varchar(50) default '',
  `Wymiar` varchar(50) default '',
  `Kolor` varchar(100) NOT NULL default '',
  `Ilosc` int(11) NOT NULL default '0',
  `CenaNetto` decimal(10,2) NOT NULL default '0.00',
  `CenaBruttoZak` decimal(10,2) default '0.00',
  PRIMARY KEY  (`id`),
  KEY `idZlecenia` (`idZlecenia`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- Zrzucanie danych dla tabeli projekt.parapetyzam: ~0 rows (około)
DELETE FROM `parapetyzam`;

-- Zrzut struktury tabela projekt.rabaty
CREATE TABLE IF NOT EXISTS `rabaty` (
  `NazwaTech` varchar(100) NOT NULL default '',
  `Rabat` int(11) NOT NULL default '0',
  `RabatTyp` int(11) NOT NULL default '0',
  `RabatDod` int(11) NOT NULL default '0',
  PRIMARY KEY  (`NazwaTech`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- Zrzucanie danych dla tabeli projekt.rabaty: 0 rows
DELETE FROM `rabaty`;

-- Zrzut struktury tabela projekt.txtoferty
CREATE TABLE IF NOT EXISTS `txtoferty` (
  `Technologia` varchar(100) NOT NULL default '',
  `Tekst` mediumtext NOT NULL,
  PRIMARY KEY  (`Technologia`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- Zrzucanie danych dla tabeli projekt.txtoferty: ~0 rows (około)
DELETE FROM `txtoferty`;

-- Zrzut struktury tabela projekt.towary
CREATE TABLE IF NOT EXISTS`towary` (
	`id` INT(11) NOT NULL AUTO_INCREMENT,
	`nazwa` VARCHAR(250) NULL DEFAULT NULL COLLATE 'utf8_general_ci',
	`cena_sprzedazy` DECIMAL(9,2) NULL DEFAULT NULL,
	`cena_zakupu` DECIMAL(9,2) NULL DEFAULT NULL,
	`uwagi` TEXT(65535) NULL DEFAULT NULL COLLATE 'utf8_general_ci',
	PRIMARY KEY (`id`)
)ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- Zrzucanie danych dla tabeli projekt.towary: ~0 rows (około)
DELETE FROM `towary`;

-- Zrzut struktury tabela projekt.ulubionedodatki
CREATE TABLE IF NOT EXISTS `ulubionedodatki` (
  `id` int(10) unsigned NOT NULL auto_increment,
  `idElementu` int(10) unsigned NOT NULL default '0',
  PRIMARY KEY  (`id`),
  KEY `idElementu` (`idElementu`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- Zrzucanie danych dla tabeli projekt.ulubionedodatki: ~0 rows (około)
DELETE FROM `ulubionedodatki`;

-- Zrzut struktury tabela projekt.waluta
CREATE TABLE IF NOT EXISTS `waluta` (
  `id` int(10) unsigned NOT NULL auto_increment,
  `Nazwa` varchar(20) NOT NULL default '',
  PRIMARY KEY  (`id`),
  KEY `nazwa` (`Nazwa`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- Zrzucanie danych dla tabeli projekt.waluta: ~1 rows (około)
DELETE FROM `waluta`;
INSERT INTO `waluta` (`id`, `Nazwa`) VALUES
	(1, 'z?');

USE `vetrex`;
-- Zrzut struktury tabela vetrex.dane
CREATE TABLE IF NOT EXISTS `dane` (
  `id` int(10) unsigned NOT NULL auto_increment,
  `Dealer` varchar(25) default NULL,
  `NRZD` varchar(15) default NULL,
  `NRZV` varchar(15) default NULL,
  `DataP` decimal(10,0) default NULL,
  `DataO` int(11) default '0',
  `Uwagi` text,
  `OfrZlec` int(2) default '0',
  `CzyWyslane` int(1) default '0',
  `IdWaluta` int(2) default '1',
  PRIMARY KEY  (`id`),
  KEY `DataP` (`DataP`),
  KEY `Dealer` (`Dealer`),
  KEY `DataO` (`DataO`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- Zrzucanie danych dla tabeli vetrex.dane: ~0 rows (około)
DELETE FROM `dane`;
